/**
 * @file
 * Base Backbone model for a Block Content Type.
 */

(function (_, $, Backbone, Drupal) {

  'use strict';

  Drupal.panels_ipe.BlockContentTypeModel = Backbone.Model.extend(/** @lends Drupal.panels_ipe.BlockContentTypeModel# */{

    /**
     * @type {object}
     */
    defaults: /** @lends Drupal.panels_ipe.BlockContentTypeModel# */{

      /**
       * The content type ID.
       *
       * @type {string}
       */
      id: null,

      /**
       * Whether or not entities of this type are revisionable by default.
       *
       * @type {bool}
       */
      revision: null,

      /**
       * The content type label.
       *
       * @type {string}
       */
      label: null,

      /**
       * The content type description.
       *
       * @type {string}
       */
      description: null
    }

  });

  /**
   * @constructor
   *
   * @augments Backbone.Collection
   */
  Drupal.panels_ipe.BlockContentTypeCollection = Backbone.Collection.extend(/** @lends Drupal.panels_ipe.BlockContentTypeCollection# */{

    /**
     * @type {Drupal.panels_ipe.BlockContentTypeModel}
     */
    model: Drupal.panels_ipe.BlockContentTypeModel,

    /**
     * @type {function}
     *
     * @return {string}
     *   The URL required to sync this collection with the server.
     */
    url: function () {
      return Drupal.panels_ipe.urlRoot(drupalSettings) + '/block_content/types';
    }

  });

}(_, jQuery, Backbone, Drupal));
