<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* themes/contrib/estore/templates/comment/comment.html.twig */
class __TwigTemplate_4fdfe7bdda1c738a5faa364e679e098a4a4c698ddd4e5656ff1946636345167f extends \Twig\Template
{
    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = [
        ];
        $this->sandbox = $this->env->getExtension('\Twig\Extension\SandboxExtension');
        $tags = ["set" => 70, "if" => 91];
        $filters = ["escape" => 82, "join" => 97, "t" => 111];
        $functions = [];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if'],
                ['escape', 'join', 't'],
                []
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->getSourceContext());

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        // line 70
        $context["classes"] = [0 => "js-comment", 1 => "comment-item", 2 => ((        // line 73
($context["user_picture"] ?? null)) ? ("with-picture") : (""))];
        // line 77
        $context["rightBarClasses"] = [0 => "right-sidebar", 1 => ((        // line 79
($context["user_picture"] ?? null)) ? ("col-sm-10") : ("col-sm-12"))];
        // line 82
        echo "<article";
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed($this->getAttribute(($context["attributes"] ?? null), "addClass", [0 => ($context["classes"] ?? null)], "method")), "html", null, true);
        echo ">
  ";
        // line 88
        echo "  <mark class=\"hidden\" data-comment-timestamp=\"";
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["new_indicator_timestamp"] ?? null)), "html", null, true);
        echo "\"></mark>

  <div class=\"row\">
    ";
        // line 91
        if (($context["user_picture"] ?? null)) {
            // line 92
            echo "      <div class=\"left-sidebar col-sm-2\">
        ";
            // line 93
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["user_picture"] ?? null)), "html", null, true);
            echo "
      </div>
    ";
        }
        // line 96
        echo "
    <div class=\"";
        // line 97
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, twig_join_filter($this->sandbox->ensureToStringAllowed(($context["rightBarClasses"] ?? null)), " "), "html", null, true);
        echo "\">
      <footer>
        <p>";
        // line 99
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["submitted"] ?? null)), "html", null, true);
        echo "</p>
        ";
        // line 105
        echo "        ";
        if (($context["parent"] ?? null)) {
            // line 106
            echo "          <p class=\"visually-hidden\">";
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["parent"] ?? null)), "html", null, true);
            echo "</p>
        ";
        }
        // line 108
        echo "        <span class=\"premalink\">
          <a href=\"";
        // line 109
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["permalink_url"] ?? null)), "html", null, true);
        echo "\">
            <i class=\"fa fa-link\" aria-hidden=\"true\"></i>
            <span class=\"text\">";
        // line 111
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->renderVar(t("Permalink"));
        echo "</span>
          </a>
        </span>
      </footer>
      <div";
        // line 115
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["content_attributes"] ?? null)), "html", null, true);
        echo ">
        ";
        // line 116
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["content"] ?? null)), "html", null, true);
        echo "
      </div>
    </div>
  </div>

</article>
";
    }

    public function getTemplateName()
    {
        return "themes/contrib/estore/templates/comment/comment.html.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  124 => 116,  120 => 115,  113 => 111,  108 => 109,  105 => 108,  99 => 106,  96 => 105,  92 => 99,  87 => 97,  84 => 96,  78 => 93,  75 => 92,  73 => 91,  66 => 88,  61 => 82,  59 => 79,  58 => 77,  56 => 73,  55 => 70,);
    }

    /** @deprecated since 1.27 (to be removed in 2.0). Use getSourceContext() instead */
    public function getSource()
    {
        @trigger_error('The '.__METHOD__.' method is deprecated since version 1.27 and will be removed in 2.0. Use getSourceContext() instead.', E_USER_DEPRECATED);

        return $this->getSourceContext()->getCode();
    }

    public function getSourceContext()
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation for comments.
 *
 * Available variables:
 * - author: Comment author. Can be a link or plain text.
 * - content: The content-related items for the comment display. Use
 *   {{ content }} to print them all, or print a subset such as
 *   {{ content.field_example }}. Use the following code to temporarily suppress
 *   the printing of a given child element:
 *   @code
 *   {{ content|without('field_example') }}
 *   @endcode
 * - created: Formatted date and time for when the comment was created.
 *   Preprocess functions can reformat it by calling format_date() with the
 *   desired parameters on the 'comment.created' variable.
 * - changed: Formatted date and time for when the comment was last changed.
 *   Preprocess functions can reformat it by calling format_date() with the
 *   desired parameters on the 'comment.changed' variable.
 * - permalink: Comment permalink.
 * - submitted: Submission information created from author and created
 *   during template_preprocess_comment().
 * - user_picture: The comment author's profile picture.
 * - status: Comment status. Possible values are:
 *   unpublished, published, or preview.
 * - title: Comment title, linked to the comment.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class may contain one or more of the following classes:
 *   - comment: The current template type; for instance, 'theming hook'.
 *   - by-anonymous: Comment by an unregistered user.
 *   - by-{entity-type}-author: Comment by the author of the parent entity,
 *     eg. by-node-author.
 *   - preview: When previewing a new or edited comment.
 *   The following applies only to viewers who are registered users:
 *   - unpublished: An unpublished comment visible only to administrators.
 * - title_prefix: Additional output populated by modules, intended to be
 *   displayed in front of the main title tag that appears in the template.
 * - title_suffix: Additional output populated by modules, intended to be
 *   displayed after the main title tag that appears in the template.
 * - content_attributes: List of classes for the styling of the comment content.
 * - title_attributes: Same as attributes, except applied to the main title
 *   tag that appears in the template.
 * - threaded: A flag indicating whether the comments are threaded or not.
 *
 * These variables are provided to give context about the parent comment (if
 * any):
 * - comment_parent: Full parent comment entity (if any).
 * - parent_author: Equivalent to author for the parent comment.
 * - parent_created: Equivalent to created for the parent comment.
 * - parent_changed: Equivalent to changed for the parent comment.
 * - parent_title: Equivalent to title for the parent comment.
 * - parent_permalink: Equivalent to permalink for the parent comment.
 * - parent: A text string of parent comment submission information created from
 *   'parent_author' and 'parent_created' during template_preprocess_comment().
 *   This information is presented to help screen readers follow lengthy
 *   discussion threads. You can hide this from sighted users using the class
 *   visually-hidden.
 *
 * These two variables are provided for context:
 * - comment: Full comment object.
 * - entity: Entity the comments are attached to.
 *
 * @see template_preprocess_comment()
 *
 * @ingroup themeable
 */
#}
{%
  set classes = [
    'js-comment',
    'comment-item',
    user_picture ? 'with-picture',
  ]
%}
{%
  set rightBarClasses = [
    'right-sidebar',
    user_picture ? 'col-sm-10' : 'col-sm-12',
  ]
%}
<article{{ attributes.addClass(classes) }}>
  {#
    Hide the \"new\" indicator by default, let a piece of JavaScript ask the
    server which comments are new for the user. Rendering the final \"new\"
    indicator here would break the render cache.
  #}
  <mark class=\"hidden\" data-comment-timestamp=\"{{ new_indicator_timestamp }}\"></mark>

  <div class=\"row\">
    {% if user_picture %}
      <div class=\"left-sidebar col-sm-2\">
        {{ user_picture }}
      </div>
    {% endif %}

    <div class=\"{{ rightBarClasses|join(' ') }}\">
      <footer>
        <p>{{ submitted }}</p>
        {#
          Indicate the semantic relationship between parent and child comments for
          accessibility. The list is difficult to navigate in a screen reader
          without this information.
        #}
        {% if parent %}
          <p class=\"visually-hidden\">{{ parent }}</p>
        {% endif %}
        <span class=\"premalink\">
          <a href=\"{{ permalink_url }}\">
            <i class=\"fa fa-link\" aria-hidden=\"true\"></i>
            <span class=\"text\">{{ 'Permalink'|t }}</span>
          </a>
        </span>
      </footer>
      <div{{ content_attributes }}>
        {{ content }}
      </div>
    </div>
  </div>

</article>
", "themes/contrib/estore/templates/comment/comment.html.twig", "/var/www/ptd.dev.invigroup.com/themes/contrib/estore/templates/comment/comment.html.twig");
    }
}
