<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* themes/contrib/bootstrap/templates/bootstrap/bootstrap-panel.html.twig */
class __TwigTemplate_5a4f469030a95e24f59cfbe3bda0667995ffca542789112be51aca6e200fc3c7 extends \Twig\Template
{
    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = [
            'heading' => [$this, 'block_heading'],
            'body' => [$this, 'block_body'],
            'footer' => [$this, 'block_footer'],
        ];
        $this->sandbox = $this->env->getExtension('\Twig\Extension\SandboxExtension');
        $tags = ["set" => 45, "if" => 53, "block" => 54];
        $filters = ["clean_class" => 47, "escape" => 50];
        $functions = [];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'escape'],
                []
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->getSourceContext());

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        // line 45
        $context["classes"] = [0 => "panel", 1 => ((        // line 47
($context["errors"] ?? null)) ? ("panel-danger") : (("panel-" . \Drupal\Component\Utility\Html::getClass($this->sandbox->ensureToStringAllowed(($context["panel_type"] ?? null))))))];
        // line 50
        echo "<div";
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed($this->getAttribute(($context["attributes"] ?? null), "addClass", [0 => ($context["classes"] ?? null)], "method")), "html", null, true);
        echo ">

  ";
        // line 53
        echo "  ";
        if (($context["heading"] ?? null)) {
            // line 54
            echo "    ";
            $this->displayBlock('heading', $context, $blocks);
            // line 69
            echo "  ";
        }
        // line 70
        echo "
  ";
        // line 72
        echo "  ";
        $this->displayBlock('body', $context, $blocks);
        // line 105
        echo "
  ";
        // line 107
        echo "  ";
        if (($context["footer"] ?? null)) {
            // line 108
            echo "    ";
            $this->displayBlock('footer', $context, $blocks);
            // line 116
            echo "  ";
        }
        // line 117
        echo "
</div>
";
    }

    // line 54
    public function block_heading($context, array $blocks = [])
    {
        // line 55
        echo "      <div class=\"panel-heading\">
        ";
        // line 57
        $context["heading_classes"] = [0 => "panel-title", 1 => ((        // line 59
($context["required"] ?? null)) ? ("form-required") : (""))];
        // line 62
        echo "        ";
        if (($context["collapsible"] ?? null)) {
            // line 63
            echo "          <a";
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed($this->getAttribute(($context["heading_attributes"] ?? null), "addClass", [0 => ($context["heading_classes"] ?? null)], "method")), "html", null, true);
            echo " href=\"";
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["target"] ?? null)), "html", null, true);
            echo "\">";
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["heading"] ?? null)), "html", null, true);
            echo "</a>
        ";
        } else {
            // line 65
            echo "          <div";
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed($this->getAttribute(($context["heading_attributes"] ?? null), "addClass", [0 => ($context["heading_classes"] ?? null)], "method")), "html", null, true);
            echo ">";
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["heading"] ?? null)), "html", null, true);
            echo "</div>
        ";
        }
        // line 67
        echo "      </div>
    ";
    }

    // line 72
    public function block_body($context, array $blocks = [])
    {
        // line 73
        echo "    ";
        // line 74
        $context["body_classes"] = [0 => "panel-body", 1 => ((        // line 76
($context["collapsible"] ?? null)) ? ("panel-collapse") : ("")), 2 => ((        // line 77
($context["collapsible"] ?? null)) ? ("collapse") : ("")), 3 => ((        // line 78
($context["collapsible"] ?? null)) ? ("fade") : ("")), 4 => (((        // line 79
($context["errors"] ?? null) || (($context["collapsible"] ?? null) &&  !($context["collapsed"] ?? null)))) ? ("in") : (""))];
        // line 82
        echo "    ";
        // line 83
        $context["description_classes"] = [0 => "help-block", 1 => (((        // line 85
($context["description"] ?? null) && ($this->getAttribute(($context["description"] ?? null), "position", []) == "invisible"))) ? ("sr-only") : (""))];
        // line 88
        echo "
    ";
        // line 89
        if (($context["errors"] ?? null)) {
            // line 90
            echo "      <div class=\"alert alert-danger\" role=\"alert\">
        <strong>";
            // line 91
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["errors"] ?? null)), "html", null, true);
            echo "</strong>
      </div>
    ";
        }
        // line 94
        echo "
    <div";
        // line 95
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed($this->getAttribute(($context["body_attributes"] ?? null), "addClass", [0 => ($context["body_classes"] ?? null)], "method")), "html", null, true);
        echo ">
      ";
        // line 96
        if ((($context["description"] ?? null) && ($this->getAttribute(($context["description"] ?? null), "position", []) == "before"))) {
            // line 97
            echo "        <p";
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed($this->getAttribute($this->getAttribute(($context["description"] ?? null), "attributes", []), "addClass", [0 => ($context["description_classes"] ?? null)], "method")), "html", null, true);
            echo ">";
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed($this->getAttribute(($context["description"] ?? null), "content", [])), "html", null, true);
            echo "</p>
      ";
        }
        // line 99
        echo "      ";
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["body"] ?? null)), "html", null, true);
        echo "
      ";
        // line 100
        if (((($context["description"] ?? null) && ($this->getAttribute(($context["description"] ?? null), "position", []) == "after")) || ($this->getAttribute(($context["description"] ?? null), "position", []) == "invisible"))) {
            // line 101
            echo "        <p";
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed($this->getAttribute($this->getAttribute(($context["description"] ?? null), "attributes", []), "addClass", [0 => ($context["description_classes"] ?? null)], "method")), "html", null, true);
            echo ">";
            echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed($this->getAttribute(($context["description"] ?? null), "content", [])), "html", null, true);
            echo "</p>
      ";
        }
        // line 103
        echo "    </div>
  ";
    }

    // line 108
    public function block_footer($context, array $blocks = [])
    {
        // line 109
        echo "      ";
        // line 110
        $context["footer_classes"] = [0 => "panel-footer"];
        // line 114
        echo "      <div";
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed($this->getAttribute(($context["footer_attributes"] ?? null), "addClass", [0 => ($context["footer_classes"] ?? null)], "method")), "html", null, true);
        echo ">";
        echo $this->env->getExtension('Drupal\Core\Template\TwigExtension')->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(($context["footer"] ?? null)), "html", null, true);
        echo "</div>
    ";
    }

    public function getTemplateName()
    {
        return "themes/contrib/bootstrap/templates/bootstrap/bootstrap-panel.html.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  209 => 114,  207 => 110,  205 => 109,  202 => 108,  197 => 103,  189 => 101,  187 => 100,  182 => 99,  174 => 97,  172 => 96,  168 => 95,  165 => 94,  159 => 91,  156 => 90,  154 => 89,  151 => 88,  149 => 85,  148 => 83,  146 => 82,  144 => 79,  143 => 78,  142 => 77,  141 => 76,  140 => 74,  138 => 73,  135 => 72,  130 => 67,  122 => 65,  112 => 63,  109 => 62,  107 => 59,  106 => 57,  103 => 55,  100 => 54,  94 => 117,  91 => 116,  88 => 108,  85 => 107,  82 => 105,  79 => 72,  76 => 70,  73 => 69,  70 => 54,  67 => 53,  61 => 50,  59 => 47,  58 => 45,);
    }

    /** @deprecated since 1.27 (to be removed in 2.0). Use getSourceContext() instead */
    public function getSource()
    {
        @trigger_error('The '.__METHOD__.' method is deprecated since version 1.27 and will be removed in 2.0. Use getSourceContext() instead.', E_USER_DEPRECATED);

        return $this->getSourceContext()->getCode();
    }

    public function getSourceContext()
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a Bootstrap Panel component.
 *
 * Available variables:
 * - attributes: An array of HTML attributes intended to be added to the main
 *   container tag of this template.
 *   - id: A valid HTML ID and guaranteed to be unique.
 * - body: The primary content of the panel.
 * - body_attributes: (optional) Same as attributes, except applied to the body
 *   container that appears in the template.
 * - collapsible: Flag indicating whether the panel is collapsible.
 * - collapsed: Flag indicating whether the panel is collapsed.
 * - description: (optional) A list of description properties containing:
 *    - content: (optional) A description of the form element, may not be set.
 *    - attributes: (optional) A list of HTML attributes to apply to the
 *      description content wrapper. Will only be set when description is set.
 *    - position: (optional) A display setting that can have these values:
 *      - before: The description is output before the element. This is the
 *        default value.
 *      - after: The description is output after the element.
 *      - invisible: The description is output after the element, hidden
 *        visually but available to screen readers.
 * - errors: (optional) Any errors for panel, may not be set.
 * - footer: (optional) Additional contents intended to be placed at the bottom.
 * - footer_attributes: (optional) Same as attributes, except applied to the
 *   footer container that appears in the template.
 * - heading: (optional) The title of the panel, may not be set.
 * - heading_attributes: (optional) Same as attributes, except applied to the
 *   heading container that appears in the template.
 * - panel_type: (optional) A contextual state. Will be one of these values:
 *   - danger
 *   - default (default value)
 *   - info
 *   - primary
 *   - success
 *   - warning
 * - target: (optional) The target of the collapsible container.
 *
 * @ingroup templates
 */
#}
{%
  set classes = [
    'panel',
    errors ? 'panel-danger' : 'panel-' ~ panel_type|clean_class,
  ]
%}
<div{{ attributes.addClass(classes) }}>

  {# Heading #}
  {% if heading %}
    {% block heading %}
      <div class=\"panel-heading\">
        {%
          set heading_classes = [
            'panel-title',
            required ? 'form-required' : '',
          ]
        %}
        {% if collapsible %}
          <a{{ heading_attributes.addClass(heading_classes) }} href=\"{{ target }}\">{{ heading }}</a>
        {% else %}
          <div{{ heading_attributes.addClass(heading_classes) }}>{{ heading }}</div>
        {% endif %}
      </div>
    {% endblock %}
  {% endif %}

  {# Body #}
  {% block body %}
    {%
      set body_classes = [
      'panel-body',
      collapsible ? 'panel-collapse',
      collapsible ? 'collapse',
      collapsible ? 'fade',
      errors or collapsible and not collapsed ? 'in',
      ]
    %}
    {%
      set description_classes = [
        'help-block',
        description and description.position == 'invisible' ? 'sr-only',
      ]
    %}

    {% if errors %}
      <div class=\"alert alert-danger\" role=\"alert\">
        <strong>{{ errors }}</strong>
      </div>
    {% endif %}

    <div{{ body_attributes.addClass(body_classes) }}>
      {% if description and description.position == 'before' %}
        <p{{ description.attributes.addClass(description_classes) }}>{{ description.content }}</p>
      {% endif %}
      {{ body }}
      {% if description and description.position == 'after' or description.position == 'invisible' %}
        <p{{ description.attributes.addClass(description_classes) }}>{{ description.content }}</p>
      {% endif %}
    </div>
  {% endblock %}

  {# Footer #}
  {% if footer %}
    {% block footer %}
      {%
        set footer_classes = [
          'panel-footer',
        ]
      %}
      <div{{ footer_attributes.addClass(footer_classes) }}>{{ footer }}</div>
    {% endblock %}
  {% endif %}

</div>
", "themes/contrib/bootstrap/templates/bootstrap/bootstrap-panel.html.twig", "/var/www/ptd.dev.invigroup.com/themes/contrib/bootstrap/templates/bootstrap/bootstrap-panel.html.twig");
    }
}
