/**
 * @file
 * JavaScript behaviors for Likert element.
 */

(function ($, Drupal) {

  'use strict';

  $(document).on('state:required', function (e) {
    if (e.trigger) {
      var $element = $('#' + e.target.id);
      // Add/remove required from the question labels.
      if ($element.hasClass('webform-likert-table')) {
        if (e.value) {
          $element.find('tr td:first-child label').addClass('js-form-required form-required');
        }
        else {
          $element.find('tr td:first-child label').removeClass('js-form-required form-required');
        }
      }
    }
  });

})(jQuery, Drupal);

